﻿#NoEnv                             ;不检查空变量是否为环境变量
#SingleInstance, Force             ;新开程序替换旧实例
#Persistent                        ;让脚本持续运行(即直到用户关闭或遇到 ExitApp).
SetBatchLines, -1                  ;让操作以最快速度进行


;强制设置工作路径为软件所在文件夹，否则使用快捷方式打开软件无法读取随同的配置文件
SetWorkingDir %A_ScriptDir%
;输出配置文件.ini，如果已经存在，不覆盖
FileInstall, 配置文件模板.ini, eye.ini, 0


;变量
AppVersion := "EYE护眼提醒 V1.0"
Startuplnk := A_StartMenu . "\Programs\Startup\eye.lnk"



;启动执行段
gosub, 读取配置

if (MainX = "ERROR" or MainY = "ERROR") ;第一次启动软件时创建自启
FileCreateShortcut, % A_ScriptFullpath, % Startuplnk

time := WorkTime
gosub, 托盘菜单
gosub, 刷新菜单
if (ShowOSD)
gosub, OSDUI
gosub, UpdateOSD  ; 立即进行第一次更新而不等待计时器.
SetTimer, UpdateOSD, 1000
return

OSDUI:
    OSDUI := 1
    ;CustomColor := "EEAA99"
    CustomColor := "EEAA99"
    Gui +LastFound -Caption +ToolWindow  ; +ToolWindow 避免显示任务栏按钮和 alt-tab 菜单项.
    Gui, Color, %CustomColor%
    Gui, Font, s30  ; 设置大字体 (32 磅).
    Gui, Add, Text, vMyText cBlack w120 h35 Center xCenter yCenter gWindowMove
    WinSet, TransColor, %CustomColor% 150 ; 让此颜色的所有像素透明且让文本显示为半透明 (150):
    if (MainX = "ERROR" or MainY = "ERROR"){
        CoordMode, Mouse, Screen
        MouseGetPos, xpos, ypos
        Gui, Show, x%xpos% y%ypos%  NoActivate
    } else Gui, Show, x%MainX% y%MainY% NoActivate

    if(TopShowOSD)
    Gui +AlwaysOnTop
    Gui -Caption
    
    ;OnMessage(0x201, "WindowMove")
    return

你好:
    MsgBox nihao 
    return

刷新菜单:
    if (FileExist(Startuplnk))
    Menu, tray, Check, 开机启动
    else Menu, tray, UnCheck, 开机启动

    if (ShowOSD){
        Menu, tray, Check, 开启屏显OSD
        Menu, tray, Enable, OSD置于顶层
    }
    else {
        Menu, tray, UnCheck, 开启屏显OSD
        Menu, tray, Disable, OSD置于顶层
    }

    if (TopShowOSD)
    Menu, tray, Check, OSD置于顶层
    else Menu, tray, UnCheck, OSD置于顶层


    if (RestTime == "10"){
        Menu, Submenu1, Check, 10秒
        Menu, Submenu1, UnCheck, 20秒（推荐）
        Menu, Submenu1, UnCheck, 30秒
        Menu, Submenu1, UnCheck, 自定义
    } else if (RestTime == "20"){
        Menu, Submenu1, UnCheck, 10秒
        Menu, Submenu1, Check, 20秒（推荐）
        Menu, Submenu1, UnCheck, 30秒
        Menu, Submenu1, UnCheck, 自定义
    } else if (RestTime == "30"){
        Menu, Submenu1, UnCheck, 10秒
        Menu, Submenu1, UnCheck, 20秒（推荐）
        Menu, Submenu1, Check, 30秒
        Menu, Submenu1, UnCheck, 自定义
    } else {
        Menu, Submenu1, UnCheck, 10秒
        Menu, Submenu1, UnCheck, 20秒（推荐）
        Menu, Submenu1, UnCheck, 30秒
        Menu, Submenu1, Check, 自定义
    }


    if (Format("{1:0.0f}", WorkTime/60) == "20"){
        Menu, Submenu0, Check, 20分钟（推荐）
        Menu, Submenu0, UnCheck, 30分钟
        Menu, Submenu0, UnCheck, 40分钟
        Menu, Submenu0, UnCheck, 自定义
    } else if (Format("{1:0.0f}", WorkTime/60) == "30"){
        Menu, Submenu0, UnCheck, 20分钟（推荐）
        Menu, Submenu0, Check, 30分钟
        Menu, Submenu0, UnCheck, 40分钟
        Menu, Submenu0, UnCheck, 自定义
    } else if (Format("{1:0.0f}", WorkTime/60) == "40"){
        Menu, Submenu0, UnCheck, 20分钟（推荐）
        Menu, Submenu0, UnCheck, 30分钟
        Menu, Submenu0, Check, 40分钟
        Menu, Submenu0, UnCheck, 自定义
    } else {
        Menu, Submenu0, UnCheck, 20分钟（推荐）
        Menu, Submenu0, UnCheck, 30分钟
        Menu, Submenu0, UnCheck, 40分钟
        Menu, Submenu0, Check, 自定义
    }
    ;text := Format("{1:0.0f}", WorkTime/60)

    return


ShowOSDControl:
    ShowOSD := !ShowOSD
    IniWrite, %ShowOSD%, eye.ini, config, ShowOSD

    if ShowOSD {
        gosub, OSDUI
        GuiControl,, MyText, % Format("{:02d}:{:02d}", time/60 , Mod(time, 60)) ;Mod取余
    } else Gui, Destroy
    gosub, 刷新菜单
    return

TopShowOSDControl:
    TopShowOSD := !TopShowOSD
    IniWrite, %TopShowOSD%, eye.ini, config, TopShowOSD

    if (TopShowOSD){
        Menu, tray, Check, OSD置于顶层
        Gui +AlwaysOnTop
    }
    else {
        Menu, tray, UnCheck, OSD置于顶层
        Gui -AlwaysOnTop
    }
    
    return

托盘菜单:
    

    Menu, Tray, NoStandard
    ;Menu, Tray, Tip, %MenuTipText%
    Menu, tray, add, 开机启动, AutoStart
    Menu, tray, add, 开启屏显OSD, ShowOSDControl
    Menu, tray, add, OSD置于顶层, TopShowOSDControl

    Menu, Submenu0, Add, 20分钟（推荐）, 设定工作时间
    Menu, Submenu0, Add, 30分钟, 设定工作时间
    Menu, Submenu0, Add, 40分钟, 设定工作时间
    Menu, Submenu0, Add, 自定义, 设定工作时间
    Menu, tray, add, 工作时间, :Submenu0

    Menu, Submenu1, Add, 10秒, 设定提醒时间
    Menu, Submenu1, Add, 20秒（推荐）, 设定提醒时间
    Menu, Submenu1, Add, 30秒, 设定提醒时间
    Menu, Submenu1, Add, 自定义, 设定提醒时间
    Menu, tray, add, 提醒时间, :Submenu1

    Menu, tray, add

    Menu, tray, add, 关于, 托盘-About
    Menu, tray, add, 退出, ExitApp
    return


设定工作时间:
    if (A_ThisMenuItem == "20分钟（推荐）")
        WorkTime := 20*60
    else if (A_ThisMenuItem == "30分钟")
        WorkTime := 30*60
    else if (A_ThisMenuItem == "40分钟")
        WorkTime := 40*60
    else if (A_ThisMenuItem == "自定义"){
        text := Format("{1:0.0f}", WorkTime/60)
        InputBox, inputTime, 输入框,请输入时间---单位(分钟),,,,,,,,%text%
        WorkTime := inputTime*60
        if (WorkTime = "")
        WorkTime := 20*60
    }
    IniWrite, %WorkTime%, eye.ini, config, WorkTime
    time := WorkTime
    text := "工作时间已设为" . Format("{1:0.0f}", WorkTime/60) "分钟"
    SetTimer, ShowTips, 0
    SetTimer, RemoveTips, -3000
    gosub, 刷新菜单
    return

设定提醒时间:
    if (A_ThisMenuItem == "10秒")
        RestTime := 10
    else if (A_ThisMenuItem == "20秒（推荐）")
        RestTime := 20
    else if (A_ThisMenuItem == "30秒")
        RestTime := 30
    else if (A_ThisMenuItem == "自定义"){
        InputBox, RestTime, 输入框,请输入时间---单位(秒),,,,,,,,%RestTime%
        if (RestTime = "")
        RestTime := 20
    }
    IniWrite, %RestTime%, eye.ini, config, RestTime
    text := "休息时间已设为" . RestTime "秒"
    SetTimer, ShowTips, 0
    SetTimer, RemoveTips, -3000
    gosub, 刷新菜单
    return

ShowTips:
    btt(text,,,,"Style1")
    return

RemoveTips:
    SetTimer, ShowTips, off
    btt()
    return


托盘-About:
    Run https://www.cnblogs.com/chr2020/p/16277452.html
    return

读取配置:
    IniRead, WorkTime, eye.ini, config, WorkTime
    IniRead, RestTime, eye.ini, config, RestTime
    IniRead, ShowOSD, eye.ini, config, ShowOSD
    IniRead, TopShowOSD, eye.ini, config, TopShowOSD
    IniRead, MainX, eye.ini, config, MainX
    IniRead, MainY, eye.ini, config, MainY
    return

ExitApp:
    ExitApp
    return

AutoStart:
    if (FileExist(Startuplnk)){
        FileDelete, % Startuplnk
        gosub, 刷新菜单
    }
    else {
        FileCreateShortcut, % A_ScriptFullpath, % Startuplnk
        gosub, 刷新菜单
    }  
    return







UpdateOSD:
    MyText := % Format("{:02d}:{:02d}", time/60 , Mod(time, 60)) ;Mod取余

    MenuTipText  := AppVersion . "`n" . "距离休息还有：" . MyText
    Menu, Tray, Tip, %MenuTipText%

    if (OSDUI)
    GuiControl,, MyText, %MyText%

    time--

    if Format("{:02d}", time/60) = 0 {
        if Format("{:02d}", Mod(time,60)) = -1 {

            text := "向远方看看"
            SetTimer, ShowTips, 0
            SetTimer, UpdateOSD, off
            SetTimer, 持续计时, -%RestTime%000
        }
    }
    return





持续计时:
    gosub, RemoveTips
    gosub, 读取配置
    time := WorkTime
    SetTimer, UpdateOSD, 1000
    return




WindowMove(){
    PostMessage, 0xA1, 2
    WinGetPos, MainX, MainY
    IniWrite, %MainX%, eye.ini, config, MainX
    IniWrite, %MainY%, eye.ini, config, MainY
}
